 		******************************
	     ******                        ******
           ****        SURFACE MAPPING         ****
	  ****     ROUTINES FOR USE IN TLB 	****
           ****	      DEVELOPMENT INTRO        ****
             ******                        ******
                ******************************

			OPT	O+,W-

*****************************USEFUL EQUATES**********************************

MARKS			EQU	0
DMA			EQU	0
	IFEQ	DMA
MEM			EQU	$200000   
	ENDC
	IFNE	DMA
MEM			EQU	$0
			ORG	$2000+$1C
	ENDC

SCREEN1			EQU	$68000+MEM
SCREEN2			EQU	$70000+MEM
SCREEN3			EQU	$78000+MEM

MAX_HEIGHT:		EQU	120

**************************END OF USEFUL EQUATES******************************

*IN THE BEGINNING THERE WAS NOTHING.................

START:
	IFEQ	DMA
	CLR.L	-(SP)
	MOVE.W	#$20,-(SP)
	TRAP	#1
	ADDQ.L	#6,SP
	MOVE.L	D0,OLDSSP
	LEA	OURSTACK,A7
	ENDC
	IFNE	DMA
	MOVE.L	A7,OLDSSP
	LEA	OURSTACK,A7
	ENDC

	MOVEM.L	$FFFF8240.W,D0-D7	STORE STANDARD PALETTE
	MOVEM.L	D0-D7,OLD_PALETTE

	IFEQ	DMA
	MOVE.W	#0,-(SP)		SWITCH INTO LOWRES
	MOVE.L	#-1,-(SP)
	MOVE.L	#-1,-(SP)
	MOVE.W	#5,-(SP)
	TRAP	#14
	ADD.L	#12,SP
	ENDC

	MOVEQ 	#$12,D0			TURN OFF MOUSE
	BSR 	IKBD
	MOVEQ 	#$1A,D0			JOYSTICK AUTO RETURN(?)
	BSR 	IKBD

	BSR	CLEAR_SCREENS

	BSR	CONVERT_GFX_FORMAT
	BSR	CREATE_PROJDIVU

	BSR	HBL_ON

MAIN_LOOP:
	LEA	LOGBASE(PC),A0		ROTATE SCREEN ADRESSES
	MOVEM.L	(A0)+,D0-D2
	MOVEM.L	D0-D1,-(A0)
	MOVE.L	D2,-(A0)
	LSR.W	#8,D0
	MOVE.L	D0,$FFFF8200.W

	BSR	CLEAR_LOGBASE

	BSR	TRANSFORM_COORDINATES
	
	BSR	DRAW_TEXTURED_SURFACE

	ADDQ.W	#1,FRAME_VARS+2

	BRA.S	MAIN_LOOP

****************************************************************************
* THE VSYNC ROUTINE
****************************************************************************

VSYNC
	TST.W	VBLIND
	BEQ.S	VSYNC
	CLR.W	VBLIND
	RTS

***************************************************************************
* THE KEYVECTOR. DEALS WITH ALL KEYPRESSES AND JOYSTICK MOVEMENTS
***************************************************************************

KEY_VECTOR				*THE NEW KEY VECTOR
	MOVE.W	#$2500,SR
	MOVE.L 	D2,-(SP)
.AGAIN	MOVE.B 	$FFFFFC00.W,D2		
	BTST 	#7,D2			ANY CHARACTER WAITING?
	BEQ.S	VECTOREND		NO THEN END
	MOVE.B 	$FFFFFC02.W,D2		READ CHARACTER INTO  'KBUFF'
	MOVE.B 	D2,KBUFF
	BTST	#4,$FFFFFA01.W
	BEQ.S	.AGAIN
VECTOREND
	MOVE.L 	(SP)+,D2
	RTE

*********************
KBUFF	DC.W	0			*THE KEY BUFFER
*********************

*****************************************************************************
* THIS IS THE QUIT ROUTINE
*****************************************************************************

QUIT
	MOVE.W 	#$2700,SR		TURN OFF INTS
	BSR 	HBLOFF			RESET VALUES
	LEA 	$FFFF8800.W,A1		BLANK SOUNDCHIP
	MOVE.L 	#$8080000,(A1)
	MOVE.L 	#$9090000,(A1)
	MOVE.L 	#$A0A0000,(A1)
	MOVE.W 	#$2300,SR		TURN BACK ON INTS
	MOVEQ 	#$14,D0			TURN MOUSE
	BSR 	IKBD	
	MOVEQ 	#$8,D0			AND JOYSTICKS BACK ON
	BSR 	IKBD
	MOVEM.L	OLD_PALETTE,D0-D7	PUT BACK OLD PALETTE
	MOVEM.L	D0-D7,$FFFF8240.W
	IFEQ	DMA
	MOVE.W	#1,-(SP)		SWITCH BACK TO MEDIUM RES
	MOVE.L	#-1,-(SP)
	MOVE.L	#-1,-(SP)
	MOVE.W	#5,-(SP)
	TRAP	#14
	ADD.L	#12,SP
	MOVE.L	OLDSSP,-(A7)		RESTORE STACK
	MOVE.W	#$20,-(SP)		AND PUT BACK INTO USER MODE
	TRAP	#1
	ADDQ.L	#6,SP

	ILLEGAL
	ENDC
	IFNE	DMA
	MOVE.L	OLDSSP,A7
	MOVE.W	#$2500,SR
	RTS
	ENDC

******************************************************************************
* ROUTINE FOR SETTING UP OF GENERAL INTERRUPTS
******************************************************************************

HBL_ON
	MOVE.L 	$FFFF8200.W,OLD_PHYS
	MOVE.L 	$120.W,OLD_TB		SAVE INTERRUPTS
	MOVE.L 	$70.W,OLD_VBL
	MOVE.L 	$118.W,OLD_KEY
	MOVE.L	$68.W,OLDHBL
	MOVE.L	$114.W,OLD_TIMER_C
	MOVE.L	$20.W,OLD_PRIV
	MOVE.B 	$FFFFFA07.W,OLD_07
	MOVE.B 	$FFFFFA09.W,OLD_09
	MOVE.B 	$FFFFFA0F.W,OLD_0F
	MOVE.B 	$FFFFFA13.W,OLD_13
	MOVE.B 	$FFFFFA1B.W,OLD_1B
	MOVE.B	$FFFFFA17.W,OLD_17
	MOVE.B	$FFFFFA1D.W,OLD_1D
	MOVE.B	$FFFFFA1F.W,OLD_1F
	MOVE.B	$FFFFFA23.W,OLD_23
	MOVE.B	$FFFFFA15.W,OLD_15
	MOVE.B	$FFFFFA11.W,OLD_11
	MOVE.B	$FFFFFA0D.W,OLD_0D
	MOVE.L	USP,A0
	MOVE.L	A0,OLD_USP
	AND.B 	#$DF,$FFFFFA09.W	THEN SET UP OURS
	AND.B 	#$FE,$FFFFFA07.W
	MOVE.L 	#TIMERB_1,$120.W	FIRST TIMER B
	MOVE.L 	#NEW_VBL,$70.W		FIRST VBL
	BCLR	#3,$FFFFFA17.W
	OR.B 	#1,$FFFFFA07.W
	OR.B 	#1,$FFFFFA13.W
	BCLR 	#6,$FFFFFA09.W		PUT IN OUR NEW 
	MOVE.L 	#KEY_VECTOR,$118.W	KEY VECTOR
	BSET 	#6,$FFFFFA09.W
	MOVE.W	#$2300,SR
	RTS

**************************************************************************
* RESTORE ALL THE PREVIOUSLY STORED INTERRUPTS
**************************************************************************

HBLOFF	MOVE.W 	SR,-(SP)		TAKE OUT ALL OF OUR INTS
	MOVE.W 	#$2700,SR
	MOVE.B 	OLD_07(PC),$FFFFFA07.W
	MOVE.B 	OLD_09(PC),$FFFFFA09.W
	MOVE.B 	OLD_0F(PC),$FFFFFA0F.W
	MOVE.B 	OLD_13(PC),$FFFFFA13.W
	MOVE.B 	OLD_1B(PC),$FFFFFA1B.W
	MOVE.B	OLD_17(PC),$FFFFFA17.W
	MOVE.B	OLD_1D(PC),$FFFFFA1D.W
	MOVE.B	OLD_1F(PC),$FFFFFA1F.W
	MOVE.B	OLD_1D(PC),$FFFFFA1D.W
	MOVE.B	OLD_15(PC),$FFFFFA15.W
	MOVE.B	OLD_11(PC),$FFFFFA11.W
	MOVE.L	OLD_USP(PC),A0
	MOVE.L	A0,USP
	MOVE.B	#180,$FFFFFA23.W
	MOVE.L 	OLD_TB(PC),$120.W
	MOVE.L 	OLD_VBL(PC),$70.W
	MOVE.L 	OLD_KEY(PC),$118.W
	MOVE.L	OLDHBL(PC),$68.W
	MOVE.L	OLD_TIMER_C(PC),$114.W
	MOVE.L	OLD_PRIV(PC),$20.W
	MOVE.L 	OLD_PHYS(PC),$FFFF8200.W
	MOVE.W 	(SP)+,SR
	RTS

**************************************************************************
* WRITE DATA TO KEYBOARD PROCESSOR. ENTER WITH VALUE IN TO BE SENT IN D0
**************************************************************************

IKBD	LEA 	$FFFFFC00.W,A1		WRITE TO THE KEYBOARD
IKLOOP	MOVE.B 	(A1),D1			PROCESSOR
	BTST 	#1,D1			READY TO RECIEVE DATA?
	BEQ.S 	IKLOOP
	MOVE.B 	D0,2(A1)		SEND DATA
	RTS

OLDSSP		DC.L	0		*OLDSTACK
OLD_PALETTE	DS.L	8		*OLD ST PALETTE
OLD_TB		DC.L	0
OLD_VBL		DC.L	0
OLD_KEY		DC.L	0
OLD_PHYS	DC.L	0
OLDHBL		DC.L	0
OLD_TIMER_C:	DC.L	0
OLD_PRIV:	DC.L	0
OLD_USP:	DC.L	0
OLD_07		DC.B	0
OLD_09		DC.B	0
OLD_0F		DC.B	0
OLD_13		DC.B	0
OLD_17		DC.B	0
OLD_1B		DC.B	0
OLD_1D		DC.B	0
OLD_1F		DC.B	0
OLD_23		DC.B	0
OLD_15		DC.B	0
OLD_0D		DC.B	0
OLD_11		DC.B	0
		EVEN
VBLIND		DC.W	0
		EVEN

********************************
*      Level 4 Interrupt       *
********************************

NEW_VBL:
	MOVE.B	#0,$FFFF8260.W
	MOVEM.L	D0-A6,-(A7)
	MOVEM.L	PALETTE(PC),D0-D7
	MOVEM.L	D0-D7,$FFFF8240.W
	ST	VBLIND
*********** FRAME RATE BIT ************	
	LEA	FRAME_VARS(PC),A0
	SUBQ.W	#1,(A0)
	BNE.S	.NO_NEW_STORE
	MOVE.W	2(A0),4(A0)
	CLR.W	2(A0)
	MOVE.W	#50,(A0)
.NO_NEW_STORE:
	MOVEQ	#0,D0
	MOVE.W	4(A0),D0
	DIVU	#10,D0
	MOVE.W	D0,D1
	ADD.W	D0,D0
	ADD.W	D0,D0
	ADD.W	D1,D0
	
	MOVE.L	LOGBASE+4(PC),A2
	LEA	COUNT_FONT(PC,D0.W),A1
	MOVE.B	(A1)+,2(A2)	
	MOVE.B	(A1)+,162(A2)	
	MOVE.B	(A1)+,322(A2)	
	MOVE.B	(A1)+,482(A2)	
	MOVE.B	(A1)+,642(A2)	
	SWAP	D0
	MOVE.W	D0,D1
	ADD.W	D0,D0
	ADD.W	D0,D0
	ADD.W	D1,D0
	LEA	COUNT_FONT(PC,D0.W),A1
	MOVE.B	(A1)+,3(A2)	
	MOVE.B	(A1)+,163(A2)	
	MOVE.B	(A1)+,323(A2)	
	MOVE.B	(A1)+,483(A2)	
	MOVE.B	(A1)+,643(A2)	

	MOVEM.L	(A7)+,D0-A6
	CMP.B	#$39,KBUFF
	BEQ	QUIT
	RTE

FRAME_VARS:
	DC.W	50,0,0

COUNT_FONT:
	DC.B	%01111000
	DC.B	%10000100
	DC.B	%10000100
	DC.B	%10000100
	DC.B	%01111000

	DC.B	%00110000
	DC.B	%01010000
	DC.B	%00010000
	DC.B	%00010000
	DC.B	%01111000

	DC.B	%01111000
	DC.B	%10000100
	DC.B	%00111000
	DC.B	%01000000
	DC.B	%11111100

	DC.B	%11111000
	DC.B	%00000100
	DC.B	%01111000
	DC.B	%00000100
	DC.B	%11111000

	DC.B	%10000000
	DC.B	%10010000
	DC.B	%11111000
	DC.B	%00010000
	DC.B	%00010000

	DC.B	%11111000
	DC.B	%10000000
	DC.B	%11111000
	DC.B	%00001000
	DC.B	%11111000

	DC.B	%11111000
	DC.B	%10000000
	DC.B	%11111000
	DC.B	%10001000
	DC.B	%11111000

	DC.B	%11111000
	DC.B	%00001000
	DC.B	%00010000
	DC.B	%00100000
	DC.B	%00100000

	DC.B	%11111000
	DC.B	%10001000
	DC.B	%11111000
	DC.B	%10001000
	DC.B	%11111000

	DC.B	%11111000
	DC.B	%10001000
	DC.B	%11111000
	DC.B	%00001000
	DC.B	%11111000

PALETTE:
	DC.W	$0000,$0300,$0400,$0510,$0200,$0070,$0070,$0070
	DC.W	$0520,$0630,$0640,$0750,$0555,$0007,$0007,$0070


*********************************
*      TIMER B INTERRUPTS       *
*********************************

TIMERB_1:
	RTE

CLEAR_SCREENS:
	LEA	MEM+$80000,A1
	LEA	SCREEN1,A0
.LOOP:	CLR.L	(A0)+
	CMP.L	A1,A0
	BLT.S	.LOOP
	RTS

BLANK:
	DS.L	16

CLEAR_LOGBASE:
	MOVE.L	LOGBASE(PC),A0
	LEA	(40*160)+48(A0),A0
	MOVEM.L	BLANK(PC),D0-D7/A1-A6

ADDIT	SET	0
	REPT	120 
	MOVEM.L	D0-D7/A1-A6,ADDIT(A0)
	MOVE.L	D0,ADDIT+56(A0)
	MOVE.L	D1,ADDIT+60(A0)
ADDIT	SET	ADDIT+160
	ENDR
	RTS

*********************************************
* ROUTINE TO DRAW A PIECE OF GRAPHICS ONTO  *
* A 2D SURFACES WITH 4 POINTS SPECIFIED     *
*********************************************

CURRENT_GFX:	DC.L	0

DRAW_TEXTURED_SURFACE:
	LEA	SURFACE_LIST(PC),A6
	MOVEQ	#5,D7
SURFACE_LOOP:
	LEA	POINTS(PC),A0
	LEA	FINAL_POINTS(PC),A5
	MOVE.W	(A6)+,D0		POINT 1
	MOVE.L	(A5,D0.W),(A0)+
	MOVE.L	(A6)+,(A0)+
	MOVE.W	(A6)+,D0		POINT 2
	MOVE.L	(A5,D0.W),(A0)+
	MOVE.L	(A6)+,(A0)+
	MOVE.W	(A6)+,D0		POINT 3
	MOVE.L	(A5,D0.W),(A0)+
	MOVE.L	(A6)+,(A0)+
	MOVE.W	(A6)+,D0		POINT 4
	MOVE.L	(A5,D0.W),(A0)+
	MOVE.L	(A6)+,(A0)+

	MOVE.L	(A6)+,CURRENT_GFX

	MOVE.L	A6,-(A7)
	MOVE.W	D7,-(A7)

	MOVE.W	-32(A0),D0
	MOVE.W	-30(A0),D1
	MOVE.W	-24(A0),D2
	MOVE.W	-22(A0),D3
	MOVE.W	-16(A0),D4
	MOVE.W	-14(A0),D5
	SUB.W	D0,D4			CHECK VISIBILITY
	SUB.W	D1,D5
	SUB.W	D0,D2
	SUB.W	D1,D3
	MULS	D4,D3
	MULS	D5,D2
	SUB.L	D2,D3
	BPL	NOTHING_TO_DRAW

	LEA	-32(A0),A0
	MOVEM.L	(A0),D0-D7
	MOVEM.L	D0-D7,32(A0)

	MOVE.L	(A0),D4
	ADDQ.L	#8,A0
	MOVE.L	D4,D1
	MOVE.L	A0,A4

	MOVE.L 	(A0),D3
	ADDQ.L	#8,A0
	CMP.W 	D3,D4
	BGE.S	.2
	MOVE.W 	D3,D4
	BRA.S	.22
.2	MOVE.L	A0,A4
	MOVE.W	D3,D1
.22
	MOVE.L 	(A0),D3
	ADDQ.L	#8,A0
	CMP.W 	D3,D4
	BGE.S	.3
	MOVE.W 	D3,D4
	BRA.S	.33
.3
	CMP.W	D3,D1
	BLE.S	.33
	MOVE.L	A0,A4
	MOVE.W	D3,D1
.33
	MOVE.L 	(A0),D3
	ADDQ.L	#8,A0
	CMP.W 	D3,D4
	BGE.S	.4
	MOVE.W 	D3,D4
	BRA.S	.44
.4
	CMP.W	D3,D1
	BLE.S	.44
	MOVE.L	A0,A4
	MOVE.W	D3,D1
.44

	LEA	24(A4),A3
	SUBQ.L	#8,A4

	SUB.W 	2(A4),D4		*ADDRESS OF TOP MOST POINT
	BEQ 	ABORT_POLY		*0 LINES TO DRAW!!

.FLAT_CHECK:
	MOVE.L 	(A4),D0
	ADDQ.L	#8,A4
	CMP.W 	2(A4),D0		*CHECK TO SEE IF BOTTOM IS FLAT
	BNE.S 	.FLAT_CHECK2
	ADDQ.L 	#8,A4			*YEP IT IS 
.FLAT_CHECK2:
	CMP.W 	-6(A3),D0
	BNE.S 	.FLAT_DONE
	SUBQ.L 	#8,A3
.FLAT_DONE:

	MOVE.L 	LOGBASE(PC),A6		*GET SCREEN ADDRESS
	LSL.W	#5,D0
	ADD.W	D0,A6
	ADD.W	D0,D0
	ADD.W	D0,D0
	ADD.W	D0,A6
	MOVE.L	A6,-(A7)

	LEA	POLYGON_IMG(PC),A0
	LEA	X_GFX_GRADIENT(PC),A5
	LEA	Y_GFX_GRADIENT(PC),A6
	LEA	GRAD_TABLE+640(PC),A1
	MOVE.W	D4,D6
.LEFT_AGAIN:
	MOVE.L 	(A3),D3
	SUBQ.L	#4,A3
	MOVE.W 	-(A3),D5
	SUB.W 	D3,D5
	CLR.W 	D3
	MOVE.W 	D5,D0
	MOVE.W 	-(A3),D1
	SUB.W 	8(A3),D1
	ADD.W	D0,D0
	MULS	(A1,D0.W),D1
	ADD.L	D1,D1

	SUB.W	D5,D6
	SWAP	D1
	SWAP	D3
	ADD.W	D5,D5	
	ADD.W	D5,D5
	NEG.W	D5
	LEA	.CALC_TABLEA1(PC),A2
	JMP	(A2,D5.W)
	REPT	MAX_HEIGHT
	ADDX.L	D1,D3
	MOVE.W	D3,(A0)+
	ENDR
.CALC_TABLEA1:

	MOVE.W	4(A3),D7		X LIGHT GRADIENT
	SUB.W	12(A3),D7
	BEQ.S	.STRAIGHT1
	MOVEQ	#0,D1
	MOVE.W	12(A3),D1
	MULS	(A1,D0.W),D7
	ADD.L	D7,D7
	SWAP	D7

	LEA	CALC_TABLE2(PC),A2
	JSR	(A2,D5.W)
	BRA.S	.PAST_STRAIGHT1
.STRAIGHT1
	LEA	CALC_TABLE4(PC),A2
	MOVE.W	D5,D1
	ASR.W	#1,D1
	MOVE.W	12(A3),D7
	JSR	(A2,D1.W)
.PAST_STRAIGHT1:
	MOVE.W	6(A3),D7		X LIGHT GRADIENT
	SUB.W	14(A3),D7
	BEQ.S	.STRAIGHT2
	MOVEQ	#0,D1
	MOVE.W	14(A3),D1
	MULS	(A1,D0.W),D7
	ADD.L	D7,D7
	SWAP	D7

	LEA	CALC_TABLE3(PC),A2
	JSR	(A2,D5.W)
	BRA.S	.PAST_STRAIGHT2
.STRAIGHT2
	LEA	CALC_TABLE5(PC),A2
	MOVE.W	D5,D1
	ASR.W	#1,D1
	MOVE.W	14(A3),D7
	JSR	(A2,D1.W)
.PAST_STRAIGHT2:

	TST.W	D6
	BNE	.LEFT_AGAIN
	
*DO RIGHT HAND OF POLYGON
.DO_RIGHT:
	LEA	POLYGON_IMG+400(PC),A0
	LEA	X_GFX_GRADIENT+400(PC),A5
	LEA	Y_GFX_GRADIENT+400(PC),A6
	MOVE.W	D4,D6
	
RIGHT_AGAIN2:
	MOVE.L 	-8(A4),D3
	MOVE.W  (A4),D1
	MOVE.W  2(A4),D5
	ADDQ.L	#8,A4
	SUB.W   D3,D5
	CLR.W   D3
	MOVE.W  D5,D0
	SUB.W   -16(A4),D1
	ADD.W	D0,D0
	MULS	(A1,D0.W),D1
	ADD.L	D1,D1

	SUB.W	D5,D6
	SWAP	D1
	SWAP	D3
	ADD.W	D5,D5	
	ADD.W	D5,D5
	NEG.W	D5
	LEA	CALC_TABLEB1(PC),A2
	JMP	(A2,D5.W)
	REPT	MAX_HEIGHT
	ADDX.L	D1,D3
	MOVE.W	D3,(A0)+
	ENDR
CALC_TABLEB1:

	MOVE.W	-4(A4),D7
	SUB.W	-12(A4),D7
	BEQ.S	.STRAIGHT3
	MULS	(A1,D0.W),D7
	ADD.L	D7,D7
	SWAP	D7
	MOVEQ	#0,D1
	MOVE.W	-12(A4),D1

	LEA	CALC_TABLE2(PC),A2
	JSR	(A2,D5.W)
	BRA.S	.PAST_STRAIGHT3
.STRAIGHT3
	LEA	CALC_TABLE4(PC),A2
	MOVE.W	D5,D1
	ASR.W	#1,D1
	MOVE.W	-12(A4),D7
	JSR	(A2,D1.W)
.PAST_STRAIGHT3:

	MOVE.W	-2(A4),D7
	SUB.W	-10(A4),D7
	BEQ.S	.STRAIGHT4
	MULS	(A1,D0.W),D7
	ADD.L	D7,D7
	SWAP	D7
	MOVEQ	#0,D1
	MOVE.W	-10(A4),D1

	LEA	CALC_TABLE3(PC),A2
	JSR	(A2,D5.W)
	BRA.S	.PAST_STRAIGHT4
.STRAIGHT4
	LEA	CALC_TABLE5(PC),A2
	MOVE.W	D5,D1
	ASR.W	#1,D1
	MOVE.W	-10(A4),D7
	JSR	(A2,D1.W)
.PAST_STRAIGHT4:

	TST.W	D6
	BNE	RIGHT_AGAIN2

	MOVE.L	(A7)+,A6
	LEA	POLYGON_IMG(PC),A0
	MOVE.L	CURRENT_GFX(PC),A1
	LEA	GRAD_TABLE+640(PC),A2
	LEA	X_GFX_GRADIENT(PC),A3
	MOVEQ	#0,D1
	SUBQ.W	#1,D4
	MOVEQ	#0,D0
.LINE_LOOP:
	MOVE.W	(A0)+,D3
	MOVE.W	398(A0),D5
	SUB.W	D3,D5			D5 IS WIDTH
	MOVE.W	400(A3),D6
	SUB.W	(A3)+,D6		GET X DISTANCE (GFX)

	MOVE.W	798+400(A3),D7		GET Y DISTANCE (GFX)
	SUB.W	798(A3),D7

	MOVE.W	D5,D2
	ADD.W	D2,D2
	MULS	(A2,D2.W),D6
	ADD.L	D6,D6
	SWAP	D6			X GFX GRADIENT
	MULS	(A2,D2.W),D7
	ADD.L	D7,D7
	ASL.L	#8,D7
	SWAP	D7			Y GFX GRADIENT

	SUBQ.W	#1,D5
	BMI.S	.FORGET_IT

	MOVE.W	D3,D2
	AND.W	#15,D3
	SUB.W	D3,D2
	LSR.W	#1,D2
	LEA	(A6,D2.W),A5

	MOVEQ	#0,D2			GET INTIAL X GFX
	MOVE.W	-2(A3),D2
	MOVEQ	#0,D1			GET INTIAL Y GFX
	MOVE.W	798(A3),D1
	LSL.W	#8,D1

	ADD.W	D3,D3
	ADD.W	D3,D3
	MOVE.L	POINT_TABLE(PC,D3.W),A4
	MOVEQ	#0,D3

	MOVE.W	D1,D3
	MOVE.B	D2,D3

	MOVE.W	D4,-(A7)
	MOVEQ	#0,D4
	MOVE.B	(A1,D3.W),D4
	ADD.L	D6,D2
	ADDX.W	D0,D2
	ADD.L	D7,D1	
	ADDX.W	D0,D1
	JSR	(A4,D4.W)	
	MOVE.W	(A7)+,D4
.FORGET_IT:
	LEA	160(A6),A6	
	DBF	D4,.LINE_LOOP
NOTHING_TO_DRAW:
	MOVE.W	(A7)+,D7
	MOVE.L	(A7)+,A6
	DBF	D7,SURFACE_LOOP
	RTS

POINT_TABLE:
	DC.L	PIXEL_0
	DC.L	PIXEL_1
	DC.L	PIXEL_2
	DC.L	PIXEL_3
	DC.L	PIXEL_4
	DC.L	PIXEL_5
	DC.L	PIXEL_6
	DC.L	PIXEL_7
	DC.L	PIXEL_8
	DC.L	PIXEL_9
	DC.L	PIXEL_10
	DC.L	PIXEL_11
	DC.L	PIXEL_12
	DC.L	PIXEL_13
	DC.L	PIXEL_14
	DC.L	PIXEL_15

	REPT	MAX_HEIGHT
	ADDX.L	D7,D1
	MOVE.W	D1,(A5)+
	ENDR
CALC_TABLE2:
	RTS

	REPT	MAX_HEIGHT
	ADDX.L	D7,D1
	MOVE.W	D1,(A6)+
	ENDR
CALC_TABLE3:
	RTS

	REPT	MAX_HEIGHT
	MOVE.W	D7,(A5)+
	ENDR
CALC_TABLE4:
	RTS

	REPT	MAX_HEIGHT
	MOVE.W	D7,(A6)+
	ENDR
CALC_TABLE5:
	RTS

POS_ROUT:	MACRO
	ADD.L	D7,D1
	ADDX.W	D0,D1
	MOVE.W	D1,D3
	ADD.L	D6,D2
	ADDX.W	D0,D2
	MOVE.B	D2,D3
	MOVE.B	(A1,D3.W),D4
	ENDM

PIXEL_ROUT:	MACRO
	OR.L	#%10000000000000001\1,4(A5)
	OR.L	#%10000000000000001\1,(A5)
	DBF	D5,.NEXT_ROUT
	RTS
	OR.W	#%1\1,6(A5)
	OR.W	#%1\1,2(A5)
	DBF	D5,.NEXT_ROUT
	RTS
	OR.W	#%1\1,4(A5)
	OR.W	#%1\1,(A5)
	DBF	D5,.NEXT_ROUT
	RTS
	OR.L	#%10000000000000001\1,(A5)
	OR.W	#%1\1,4(A5)
	DBF	D5,.NEXT_ROUT
	RTS
	OR.W	#%1,6(A5)
	OR.L	#%10000000000000001\1,2(A5)
	DBF	D5,.NEXT_ROUT
	RTS
	OR.W	#%1\1,(A5)

	OR.W	#%1\1,6(A5)
	DBF	D5,.NEXT_ROUT
	RTS
	OR.W	#%1\1,(A5)
	OR.L	#%10000000000000001\1,4(A5)
	DBF	D5,.NEXT_ROUT
	RTS
	OR.L	#%10000000000000001\1,(A5)
	OR.W	#%1\1,6(A5)
	DBF	D5,.NEXT_ROUT
	RTS
	ENDM

PIXEL_0_NEXT_ROUT:
	JMP	PIXEL_0(PC,D4.W)

PIXEL_0:
	PIXEL_ROUT	000000000000000
.NEXT_ROUT:
	POS_ROUT
	JMP	PIXEL_1(PC,D4.W)
	
PIXEL_1:
	PIXEL_ROUT	00000000000000
.NEXT_ROUT:
	POS_ROUT
	JMP	PIXEL_2(PC,D4.W)
	
PIXEL_2:
	PIXEL_ROUT	0000000000000
.NEXT_ROUT:
	POS_ROUT
	JMP	PIXEL_3(PC,D4.W)
	
PIXEL_3:
	PIXEL_ROUT	000000000000
.NEXT_ROUT:
	POS_ROUT
	JMP	PIXEL_4(PC,D4.W)
	
PIXEL_4:
	PIXEL_ROUT	00000000000
.NEXT_ROUT:
	POS_ROUT
	JMP	PIXEL_5(PC,D4.W)
	
PIXEL_5:
	PIXEL_ROUT	0000000000
.NEXT_ROUT:
	POS_ROUT
	JMP	PIXEL_6(PC,D4.W)
	
PIXEL_6:
	PIXEL_ROUT	000000000
.NEXT_ROUT:
	POS_ROUT
	JMP	PIXEL_7(PC,D4.W)
	
PIXEL_7:
	PIXEL_ROUT	00000000
.NEXT_ROUT:
	POS_ROUT
	JMP	PIXEL_8(PC,D4.W)
	
PIXEL_8:
	PIXEL_ROUT	0000000
.NEXT_ROUT:
	POS_ROUT
	JMP	PIXEL_9(PC,D4.W)
	
PIXEL_9:
	PIXEL_ROUT	000000
.NEXT_ROUT:
	POS_ROUT
	JMP	PIXEL_10(PC,D4.W)
	
PIXEL_10:
	PIXEL_ROUT	00000
.NEXT_ROUT:
	POS_ROUT
	JMP	PIXEL_11(PC,D4.W)
	
PIXEL_11:
	PIXEL_ROUT	0000
.NEXT_ROUT:
	POS_ROUT
	JMP	PIXEL_12(PC,D4.W)
	
PIXEL_12:
	PIXEL_ROUT	000
.NEXT_ROUT:
	POS_ROUT
	JMP	PIXEL_13(PC,D4.W)
	
PIXEL_13:
	PIXEL_ROUT	00
.NEXT_ROUT:
	POS_ROUT
	JMP	PIXEL_14(PC,D4.W)

PIXEL_14:
	PIXEL_ROUT	0
.NEXT_ROUT:
	POS_ROUT
	JMP	PIXEL_15(PC,D4.W)
	
PIXEL_15:
	PIXEL_ROUT	
.NEXT_ROUT:
	ADDQ.W	#8,A5
	POS_ROUT
	BRA	PIXEL_0_NEXT_ROUT
	

ABORT_POLY:	RTS

BASE_COL:
C15:	OR.L	#%10000000000000001,4(A5)
C3:	OR.L	#%10000000000000001,(A5)
C0:	DBF	D5,NEXT_ROUT
	RTS
C10:	OR.W	#%1,6(A5)
C2:	OR.W	#%1,2(A5)
	DBF	D5,NEXT_ROUT
	RTS
C5:	OR.W	#%1,4(A5)
C1:	OR.W	#%1,(A5)
	DBF	D5,NEXT_ROUT
	RTS
C7:	OR.L	#%10000000000000001,(A5)
C4:	OR.W	#%1,4(A5)
	DBF	D5,NEXT_ROUT
	RTS
C14:	OR.W	#%1,6(A5)
C6:	OR.L	#%10000000000000001,2(A5)
	DBF	D5,NEXT_ROUT
	RTS
C9:	OR.W	#%1,(A5)
C8:	OR.W	#%1,6(A5)
	DBF	D5,NEXT_ROUT
	RTS
C13:	OR.W	#%1,(A5)
C12:	OR.L	#%10000000000000001,4(A5)
	DBF	D5,NEXT_ROUT
	RTS
C11:	OR.L	#%10000000000000001,(A5)
	OR.W	#%1,6(A5)
	DBF	D5,NEXT_ROUT
	RTS

NEXT_ROUT:

************************************************
* CONVERTS A 4 PLANE PIECE OF GRAPHICS 64*64   *
* INTO A LIST OF BYTES. WHERE 4 BITS = COLOR   *
************************************************

CONVERT_GFX_FORMAT:
	LEA	MAPPING_GFX(PC),A0
	LEA	GFX_DATA(PC),A1
	MOVE.W	#64*3-1,D7
.LOOP_WORD:
	MOVEQ	#3,D5
.LINE_LOOP
	MOVEM.W	(A0)+,D0-D3
	MOVE.W	#15,D6
.LOOP_BIT:
	MOVEQ	#0,D4
	ROL.W	#1,D0
	BCC.S	.NO_PLANE1
	ADDQ.W	#1,D4
.NO_PLANE1:
	ROL.W	#1,D1
	BCC.S	.NO_PLANE2
	ADDQ.W	#2,D4
.NO_PLANE2:
	ROL.W	#1,D2
	BCC.S	.NO_PLANE3
	ADDQ.W	#4,D4
.NO_PLANE3:
	ROL.W	#1,D3
	BCC.S	.NO_PLANE4
	ADDQ.W	#8,D4
.NO_PLANE4:
	MOVE.B	COLOR_OFFSET_TABLE(PC,D4.W),(A1)+
	DBF	D6,.LOOP_BIT
	DBF	D5,.LINE_LOOP
	LEA	256-64(A1),A1
	DBF	D7,.LOOP_WORD
	RTS

COLOR_OFFSET_TABLE:
	DC.B	C0-BASE_COL
	DC.B	C1-BASE_COL
	DC.B	C2-BASE_COL
	DC.B	C3-BASE_COL
	DC.B	C4-BASE_COL
	DC.B	C5-BASE_COL
	DC.B	C6-BASE_COL
	DC.B	C7-BASE_COL
	DC.B	C8-BASE_COL
	DC.B	C9-BASE_COL
	DC.B	C10-BASE_COL
	DC.B	C11-BASE_COL
	DC.B	C12-BASE_COL
	DC.B	C13-BASE_COL
	DC.B	C14-BASE_COL
	DC.B	C15-BASE_COL

POINTS:
***********************   X,  Y, GFX_X,GFX_Y
		DS.W	4*4*2


*****************************************************	
*	THIS IS THE COORDINATE CALCULATION ROUTINE
*****************************************************

TRANSFORM_COORDINATES:
	LEA 	TRIGBUFF(PC),A2	
	LEA 	SINTAB(PC),A0		GET SINE TABLE
	LEA 	180(A0),A1		COS= SIN + 90 DEGREES! (HARD THAT ONE!)
	LEA	OFFSET_TABLE(PC),A3
	MOVEM.W (A3),D0-D2	  	GET THE X,Y,Z ANGLE OF OBJECT  	
	ADD.W 	D0,D0			MAKE WORD LENGTH
	MOVE.W 	(A0,D0.W),(A2)+		PUTIN BUFFER
	MOVE.W 	(A1,D0.W),(A2)+
	ADD.W 	D1,D1
	MOVE.W 	(A0,D1.W),(A2)+
	MOVE.W 	(A1,D1.W),(A2)+	
	ADD.W 	D2,D2
	MOVE.W 	(A0,D2.W),(A2)+
	MOVE.W 	(A1,D2.W),(A2)
	LEA 	-10(A2),A0		BACK TO START OF SIN AND COS VALUES FOR 

	LEA 	MATRIX(PC),A1		GET MATRIX STORE
* sinz*sinx(used twice) - D3
	MOVE 	8(A0),D0		sinz
	MOVE 	(A0),D3			sinx
	MULS 	D0,D3
	ADD.L 	D3,D3
	SWAP 	D3			SINX * SINZ
* sinz*cosx(used twice) - D4
	MOVE 	2(A0),D4 		cosx(d0=sinz already)
	MULS 	D0,D4
	ADD.L 	D4,D4
	SWAP 	D4
* Matrix(1,1) cosy*cosx-siny*sinz*sinx
	MOVE 	6(A0),D0  		cosy
	MOVE 	2(A0),D1  		cosx
	MULS 	D1,D0			cosy*cosx
	MOVE 	4(A0),D1		siny
	MULS 	D3,D1			
	SUB.L 	D1,D0
	ADD.L 	D0,D0
	SWAP 	D0			siny*(sinz*sinx)
	MOVE 	D0,(A1)+
* Matrix(2,1) siny*cosx+cosy*sinz*sinx 
	MOVE 	4(A0),D0		siny
	MOVE 	2(A0),D1		cosx
	MULS 	D1,D0			siny*cosx
	MOVE 	6(A0),D1		cosy
	MULS 	D3,D1			
	ADD.L 	D1,D0
	ADD.L 	D0,D0
	SWAP 	D0			cosy*(sinz*sinx)
	MOVE 	D0,(A1)+
* Matrix(3,1) -cosz*sinx
	MOVE 	10(A0),D0		cosz
	NEG D0
	MOVE 	(A0),D1			sinx
	MULS 	D1,D0
	ADD.L 	D0,D0
	SWAP 	D0			cosz*sinx
	MOVE 	D0,(A1)+
* Matrix(1,2) -siny*cosz
	MOVE 	4(A0),D0		siny
	NEG 	D0			-siny
	MOVE 	10(A0),D1		cosz
	MULS 	D1,D0
	ADD.L 	D0,D0
	SWAP 	D0			siny*cosz
	MOVE 	D0,(A1)+
* Matrix(2,2) cosy*cosz		
	MOVE 	6(A0),D0		cosy
	MOVE 	10(A0),D1		cosz
	MULS 	D1,D0
	ADD.L 	D0,D0
	SWAP 	D0
	MOVE 	D0,(A1)+
* Matrix(3,2) sinz 
	MOVE 	8(A0),(A1)+
* Matrix(1,3) cosy*sinx+siny*sinz*cosx
	MOVE 	6(A0),D0		cosy
	MOVE 	(A0),D1			sinx
	MULS 	D1,D0			cosy*sinx
	MOVE 	4(A0),D1		siny
	MULS 	D4,D1
	ADD.L 	D1,D0
	ADD.L 	D0,D0
	SWAP 	D0			siny*(sinz*cosx)
	MOVE 	D0,(A1)+
* Matrix(2,3) siny*sinx-cosy*sinz*cosx
	MOVE 	4(A0),D0		siny
	MOVE 	(A0),D1		sinx
	MULS 	D1,D0			siny*sinx		
	MOVE 	6(A0),D1		cosy
	MULS 	D4,D1	
	SUB.L 	D1,D0
	ADD.L 	D0,D0
	SWAP 	D0			cosy*(sinz*cosx)
	MOVE 	D0,(A1)+
* Matrix(3,3) cosz*cosx
	MOVE 	10(A0),D0		cosz
	MOVE 	2(A0),D1		cosx
	MULS 	D1,D0
	ADD.L 	D0,D0
	SWAP 	D0			cosz*cosx
	MOVE 	D0,(A1)

	LEA 	MATRIX(PC),A2		POINTER FOR ROTATION MATRIX
	MOVEA 	#160,A3			CENTRE	X
	MOVEA 	#100,A6			CENTRE	Y
	LEA	DIVUTAB,A4
	MOVE.W 	#7,D7			NUMBER OF POINTS
	LEA 	COORDATA(PC),A0
	LEA 	OFFSET_TABLE+6(PC),A5	OFFSET POSITIONS
	LEA	FINAL_POINTS(PC),A1
TRANSLATE:
	MOVEM.W (A0),D0-D2	
	ADD.W 	(A5),D0
	ADD.W 	2(A5),D1
	MOVE.W 	D0,D3	
	MOVE.W 	D1,D4			
	MOVE.W 	D2,D5
	MULS 	(A2)+,D0			
	MULS 	(A2)+,D1		
	MULS 	(A2)+,D2
	ADD.L 	D1,D0
	ADD.L 	D2,D0
	ADD.L 	D0,D0
	SWAP 	D0			
	MULS 	(A2)+,D3
	MULS 	(A2)+,D4		
	MULS 	(A2)+,D5
	ADD.L 	D4,D3
	ADD.L 	D5,D3
	ADD.L 	D3,D3
	SWAP 	D3			
	MOVEM.W (A0)+,D1/D2/D4
	MULS 	(A2)+,D1
	MULS 	(A2)+,D2		
	MULS 	(A2)+,D4
	ADD.L 	D1,D4
	ADD.L 	D2,D4
	ADD.L 	D4,D4
	SWAP 	D4			
	ADD.W 	4(A5),D4

	ADD.W	D4,D4			*
	MOVE.W	(A4,D4.W),D1		*PERSPECTIVE
	MULS	D1,D0			*CALCULATION
	MULS	D1,D3			*USING TABLE
	SWAP	D0			*
	SWAP	D3			*

	ADD.W	A3,D0			ADD CENTREX
	ADD.W	A6,D3			ADD CENTREY

	MOVE.W 	D0,(A1)+
	MOVE.W 	D3,(A1)+
	LEA 	-18(A2),A2		
	DBF 	D7,TRANSLATE

	MOVEQ	#0,D0
	MOVE.B	KBUFF(PC),D0
	CMP.B	#$4E,D0
	BNE.S	.NO_PLUS
	CMP.W	#3000,Z_OFFSET
	BEQ.S	.NO_PLUS
	ADD.W	#10,Z_OFFSET
.NO_PLUS
	CMP.B	#$4A,D0
	BNE.S	.NO_MINUS
	CMP.W	#1200,Z_OFFSET
	BEQ.S	.NO_MINUS
	SUB.W	#10,Z_OFFSET
.NO_MINUS
	ADDQ.W	#2,X_ANGLE
	ADDQ.W	#4,Y_ANGLE		
	ADDQ.W	#6,Z_ANGLE

	CMP.W	#360,X_ANGLE
	BLT.S	.1
	SUB.W	#360,X_ANGLE
.1	CMP.W	#360,Y_ANGLE
	BLT.S	.2
	SUB.W	#360,Y_ANGLE
.2	CMP.W	#360,Z_ANGLE
	BLT.S	.3
	SUB.W	#360,Z_ANGLE
.3	RTS

OFFSET_TABLE:
X_ANGLE:	DC.W	0
Y_ANGLE:	DC.W	0
Z_ANGLE:	DC.W	0
X_OFFSET:	DC.W	0
Y_OFFSET:	DC.W	0
Z_OFFSET:	DC.W	1500

COORDATA:
	DC.W	-200,-200,-200
	DC.W	200,-200,-200
	DC.W	200,200,-200
	DC.W	-200,200,-200
	DC.W	-200,-200,200
	DC.W	200,-200,200
	DC.W	200,200,200
	DC.W	-200,200,200

SURFACE_LIST:
	DC.W	0*4,0,0,1*4,73,0,2*4,73,56,3*4,0,56
	DC.L	GFX_DATA
	DC.W	1*4,0,0,5*4,73,0,6*4,73,56,2*4,0,56
	DC.L	GFX_DATA
	DC.W	4*4,0,0,5*4,73,0,1*4,73,56,0*4,0,56
	DC.L	GFX_DATA
	DC.W	3*4,0,0,2*4,73,0,6*4,73,56,7*4,0,56
	DC.L	GFX_DATA
	DC.W	5*4,0,0,4*4,73,0,7*4,73,56,6*4,0,56
	DC.L	GFX_DATA
	DC.W	4*4,0,0,0*4,73,0,3*4,73,56,7*4,0,56
	DC.L	GFX_DATA

FINAL_POINTS:	DS.W	2*8

************************
* THE SIN TABLE DATA IN RANGE -32767 TO 32767
*************************

SINTAB	
	INCBIN F:\NEW_GAME\INTRO\TEXTURE\SIN_TAB.DAT"

CREATE_PROJDIVU
	LEA	DIVUTAB,A0
	MOVE.L	#(16777216*3)/2,D1
	MOVE.L	#16384,D2
	MOVE.W	#16383,D0
PROJ_LOOP1
	MOVE.L	D2,D3
	SUB.L	D0,D3
	LSL.L	#1,D3
	MOVE.L	D1,D4
	DIVU	D3,D4
	MOVE.W	D4,(A0)+
	SUBQ.W	#1,D0
	CMP.W	#8192,D0
	BNE.S	PROJ_LOOP1
	RTS

LOGBASE:	DC.L	SCREEN1,SCREEN2,SCREEN3

MAPPING_GFX:	INCBIN	LOGO.OBJ
GRAD_TABLE:	INCBIN	F:\NEW_GAME\GRAD_TAB.DAT

	SECTION	BSS

TRIGBUFF:	DS.W 	6
MATRIX:		DS.W 	9
POLYGON_IMG:	DS.W	400
X_GFX_GRADIENT:	DS.W	400
Y_GFX_GRADIENT:	DS.W	400
GFX_DATA:	DS.B	(64*256)
DIVUTAB:	DS.B	16384
		DS.L	100
OURSTACK:
